package com.ejie.ab04b.dao.temp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DocumentosOS2TempDaoImpl generated by UDA, 29-jun-2017 10:57:17.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class DocumentosOS2TempDaoImpl implements DocumentosOS2TempDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT_COLUMNAS = "SELECT t1.ID_TIPO_DOC_091 IDTIPODOC091,t1.DESCRIPCION_ES_091 DESCRIPCIONES091,"
			+ " t1.DESCRIPCION_EU_091 DESCRIPCIONEU091, t1.TIPO_DOKUSI_091 TIPODOKUSI091, t1.ASUNTO_DOKUSI_091 ASUNTODOKUSI091, "
			+ " t1.APORT_GEN_091 APORTGEN091, t2.ID_DOCUMENTO_027 IDDOCUMENTO027, t2.TEROS2_027 TEROS2027, "
			+ " t2.ANOOS2_027 ANOOS2027,  t2.NUMOS2_027 NUMOS2027, "
			+ " t2.ID_TIPO_DOC_027 IDTIPODOC027, t2.RUTA_PIF_027 RUTAPIF027, t2.NOMBRE_DOC_027 NOMBREDOC027, "
			+ " t2.OID_DOKUSI_027 OIDDOKUSI027 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoOS2> rwMap = new RowMapper<DocumentoOS2>() {
		public DocumentoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			DocumentoOS2 documento = new DocumentoOS2(
					resultSet.getLong("IDDOCUMENTO027"), null, null,
					resultSet.getString("RUTAPIF027"),
					resultSet.getString("NOMBREDOC027"),
					resultSet.getString("OIDDOKUSI027"), new TipoDocumento(
							resultSet.getLong("IDTIPODOC027")), null, null,
					null, new TramiteOS2(null, null, new OS2(
							resultSet.getString("TEROS2027"),
							resultSet.getString("ANOOS2027"),
							resultSet.getInt("NUMOS2027"))));
			return documento;
		}
	};

	private RowMapper<DocumentoOS2> rwMapTipo = new RowMapper<DocumentoOS2>() {
		public DocumentoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoOS2 documento = new DocumentoOS2(
					resultSet.getLong("IDDOCUMENTO027"), null, null,
					resultSet.getString("RUTAPIF027"),
					resultSet.getString("NOMBREDOC027"),
					resultSet.getString("OIDDOKUSI027"), new TipoDocumento(
							resultSet.getLong("IDTIPODOC027")), null, null,
					null, new TramiteOS2(null, null, new OS2(
							resultSet.getString("TEROS2027"),
							resultSet.getString("ANOOS2027"),
							resultSet.getInt("NUMOS2027"))));

			documento.setTipoDocumento(new TipoDocumento((resultSet
					.getLong("IDTIPODOC027") == 0 ? resultSet
					.getLong("IDTIPODOC091") : resultSet
					.getLong("IDTIPODOC027")), resultSet
					.getString("DESCRIPCIONES091"), resultSet
					.getString("DESCRIPCIONEU091"), resultSet
					.getString("TIPODOKUSI091"), resultSet
					.getString("ASUNTODOKUSI091"), resultSet
					.getString("APORTGEN091")));

			return documento;
		}
	};

	private RowMapper<DocumentoOS2> rwMapPK = new RowMapper<DocumentoOS2>() {
		public DocumentoOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentoOS2(resultSet.getLong("IDDOCUMENTO027"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0427stemp table.
	 * 
	 * ab0427stemp Ab0427stemp Ab0427stemp
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @return the documento os2
	 */
	public DocumentoOS2 add(DocumentoOS2 ab0427stemp) {
		String query = "INSERT INTO AB0427S00 (ID_DOCUMENTO_027, TEROS2_027, ANOOS2_027, NUMOS2_027, RUTA_PIF_027, NOMBRE_DOC_027, ID_TIPO_DOC_027) VALUES (?,?,?,?,?,?,?)";

		Long idDocumentoTemp = UtilDAO.getNextId(this.jdbcTemplate,
				Secuencias.DOC_OS2_TEMP.getCodSecuencia());

		ab0427stemp.setIdDocumento094(idDocumentoTemp);

		this.jdbcTemplate.update(query, ab0427stemp.getIdDocumento094(),
				ab0427stemp.getTramiteOS2().getos2().getTeros2060(),
				ab0427stemp.getTramiteOS2().getos2().getAnoos2060(),
				ab0427stemp.getTramiteOS2().getos2().getNumos2060(),
				ab0427stemp.getRutaPif094(), ab0427stemp.getNombreDoc094(),
				ab0427stemp.getTipoDocumento().getIdTipoDoc091());
		return ab0427stemp;
	}

	/**
	 * Updates a single row in the Ab0427stemp table.
	 * 
	 * ab0427stemp Ab0427stemp Ab0427stemp
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @return the documento os2
	 */
	public DocumentoOS2 update(DocumentoOS2 ab0427stemp) {
		String query = "UPDATE AB0427S00 SET TEROS2_027=?, ANOOS2_027=?, NUMOS2_027=?, RUTA_PIF_027=?, NOMBRE_DOC_027=?, ID_TIPO_DOC_027=?, OID_DOKUSI_027=? WHERE ID_DOCUMENTO_027=?";
		this.jdbcTemplate.update(query, ab0427stemp.getTramiteOS2().getos2()
				.getTeros2060(), ab0427stemp.getTramiteOS2().getos2()
				.getAnoos2060(), ab0427stemp.getTramiteOS2().getos2()
				.getNumos2060(), ab0427stemp.getRutaPif094(), ab0427stemp
				.getNombreDoc094(), ab0427stemp.getTipoDocumento()
				.getIdTipoDoc091(), ab0427stemp.getOidDokusi094(), ab0427stemp
				.getIdDocumento094());
		return ab0427stemp;
	}

	/**
	 * Finds a single row in the Ab0427stemp table.
	 * 
	 * ab0465stemp Ab0427stemp Ab0427stemp
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @return the documento os2
	 */
	@Transactional(readOnly = true)
	public DocumentoOS2 find(DocumentoOS2 ab0427stemp) {
		String query = "SELECT t1.ID_DOCUMENTO_027 IDDOCUMENTO027,t1.TEROS2_027 TEROS2027,t1.ANOOS2_027 ANOOS2027,t1.NUMOS2_027 NUMOS2027, t1.RUTA_PIF_027 RUTAPIF027, t1.NOMBRE_DOC_027 NOMBREDOC027, t1.ID_TIPO_DOC_027 IDTIPODOC027, t1.OID_DOKUSI_027 OIDDOKUSI027 FROM AB0427S00 t1  WHERE t1.ID_DOCUMENTO_027 = ?  ";

		List<DocumentoOS2> ab0427stempList = this.jdbcTemplate.query(query,
				this.rwMap, ab0427stemp.getIdDocumento094());
		return (DocumentoOS2) DataAccessUtils.uniqueResult(ab0427stempList);
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento DocumentoOS2
	 * 
	 * List<DocumentoOS2>.
	 * 
	 * @param documento
	 *            the documento os2
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS2> buscarDocumentosOS2TempTipo(DocumentoOS2 documento) {
		StringBuilder query = new StringBuilder(
				DocumentosOS2TempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0427S00 t2 ON  t2.ID_TIPO_DOC_027  = t1.ID_TIPO_DOC_091 ");
		query.append(" AND t2.TEROS2_027 = ? AND t2.ANOOS2_027 = ? AND t2.NUMOS2_027 = ?  WHERE t1.APORT_GEN_091    = ? ");
		query.append(" AND t1.ASUNTO_DOKUSI_091 != '"
				+ Constantes.TIPO_DOC_INFORME_INSPECCION
				+ "' AND t1.ID_TIPO_DOC_091='6' ");
		query.append(" order by t1.ORDER_091 ");

		return (List<DocumentoOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTipo, documento.getTramiteOS2().getos2()
						.getTeros2060(), documento.getTramiteOS2().getos2()
						.getAnoos2060(), documento.getTramiteOS2().getos2()
						.getNumos2060(), documento.getTipoDocumento()
						.getAportGen091());
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento SolicDocAperturas
	 * 
	 * List<SolicDocAperturas>.
	 * 
	 * @param documento
	 *            the documento
	 * @return the list
	 */
	/*
	 * @Transactional(readOnly = true) public List<DocumentoAperturas>
	 * buscarDocumentosAperturasInspeccion( DocumentoAperturas documento) {
	 * StringBuilder query = new StringBuilder(
	 * DocumentosOS2TempDaoImpl.QUERY_SELECT_COLUMNAS); query.append(
	 * " FROM AB0491S00 t1 LEFT JOIN AB0498S00 t2 ON  t2.ID_TIPO_DOC_098  = t1.ID_TIPO_DOC_091 "
	 * );
	 * query.append(" AND t2.ID_APERTURA_098 = ?  WHERE t1.APORT_GEN_091    = ? "
	 * ); query.append(" AND t1.ASUNTO_DOKUSI_091 = '" +
	 * Constantes.TIPO_DOC_INFORME_INSPECCION + "' ");
	 * 
	 * return (List<DocumentoAperturas>) this.jdbcTemplate.query(
	 * query.toString(), this.rwMapTipo, documento.getIdapetemp065(),
	 * documento.getTipoDocumento().getAportGen091()); }
	 */

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 * documento SolicDocAperturas
	 * 
	 * List<SolicDocAperturas>.
	 * 
	 * @param documento
	 *            the documento
	 * @return the list
	 */

	@Transactional(readOnly = true)
	public List<DocumentoOS2> buscarDocumentosOS2Temp(DocumentoOS2 documento) {
		StringBuilder query = new StringBuilder(
				DocumentosOS2TempDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(" FROM AB0491S00 t1 LEFT JOIN AB0427S00 t2 ON  t2.ID_TIPO_DOC_027  = t1.ID_TIPO_DOC_091 ");
		query.append(" WHERE t2.TEROS2_027 = ?  ");
		query.append(" AND t2.ANOOS2_027 = ?  ");
		query.append(" AND t2.NUMOS2_027 = ?  ");
		query.append(" order by idtipodoc091 ");

		return (List<DocumentoOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMapTipo, documento.getTramiteOS2().getos2()
						.getTeros2060(), documento.getTramiteOS2().getos2()
						.getAnoos2060(), documento.getTramiteOS2().getos2()
						.getNumos2060());
	}

	/**
	 * Finds a list of rows in the SolicDocumentos table.
	 * 
	 * solicdocumentos SolicDocumentos jqGridRequestDto JQGridRequestDto List
	 * <DocumentoOS2>
	 * 
	 * @param solicdocumentos
	 *            the solicdocumentos
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	/*
	 * @Transactional(readOnly = true) public List<>
	 * buscarPorIdApeYMetadatoNombre( DocumentoAperturas solicdocumentos,
	 * JQGridRequestDto jqGridRequestDto) { StringBuilder query = new
	 * StringBuilder( DocumentosOS2TempDaoImpl.QUERY_SELECT_COLUMNAS);
	 * query.append(
	 * " FROM AB0491S00 t1 LEFT JOIN AB0498S00 t2 ON  t2.ID_TIPO_DOC_098  = t1.ID_TIPO_DOC_091 "
	 * ); query.append(
	 * " WHERE t2.ID_APERTURA_098  = ? AND UPPER(SUBSTR(t2.NOMBRE_DOC_098, 1, INSTR(t2.NOMBRE_DOC_098, '.', -1) - 1)) = ? "
	 * ); // El metadato object_name nos devuelve el nombre del fichero en //
	 * minúsculas y sin extensión // Buscamos ese nombre en mayúsculas
	 * descartando lo que haya en BD a // partir del último punto
	 * 
	 * if (jqGridRequestDto != null) { query =
	 * JQGridManager.getPaginationQuery(jqGridRequestDto, query); }
	 * 
	 * return (List<DocumentoAperturas>) this.jdbcTemplate.query(query
	 * .toString(), this.rwMap, solicdocumentos.getIdapetemp065(),
	 * solicdocumentos.getNombreDoc065().toUpperCase()); }
	 */

	/**
	 * Removes a single row in the Ab0427stemp table.
	 * 
	 * ab0427stemp Ab0427stemp
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 */
	public void remove(DocumentoOS2 ab0427stemp) {
		String query = "DELETE FROM AB0427S00 WHERE ID_DOCUMENTO_027=?";
		this.jdbcTemplate.update(query, ab0427stemp.getIdDocumento094());
	}

	/**
	 * Removes a single row in the Ab0427stemp table.
	 * 
	 * ab0427stemp Ab0427stemp
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 */
	public void removeByIdApertura(DocumentoOS2 ab0427stemp) {
		String query = "DELETE FROM AB0427S00 WHERE TEROS2_027=? AND ANOOS2_027=? AND NUMOS2_027=?";
		this.jdbcTemplate.update(query, ab0427stemp.getTramiteOS2().getos2()
				.getTeros2060(), ab0427stemp.getTramiteOS2().getos2()
				.getAnoos2060(), ab0427stemp.getTramiteOS2().getos2()
				.getNumos2060());
	}

	/**
	 * Finds a list of rows in the Ab0427stemp table.
	 * 
	 * ab0427stemp Ab0427stemp jqGridRequestDto JQGridRequestDto List
	 * <Ab0427stemp>
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS2> findAll(DocumentoOS2 ab0427stemp,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DOCUMENTO_027 IDDOCUMENTO027,t1.TEROS2_027 TEROS2027,t1.ANOOS2_027 ANOOS2027,t1.NUMOS2_027 NUMOS2027,t1.RUTA_PIF_027 RUTAPIF027,t1.NOMBRE_DOC_027 NOMBREDOC027,t1.ID_TIPO_DOC_027 IDTIPODOC027 ");
		query.append("FROM AB0427S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0427stemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0427stemp table using like.
	 * 
	 * ab0465stemp Ab0427stemp jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab0427stemp>
	 * 
	 * @param ab0427stemp
	 *            the ab 0465 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS2> findAllLike(DocumentoOS2 ab0427stemp,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DOCUMENTO_027 IDDOCUMENTO027,t1.TEROS2_027 TEROS2027,t1.ANOOS2_027 ANOOS2027,t1.NUMOS2_027 NUMOS2027,t1.RUTA_PIF_027 RUTAPIF027,t1.NOMBRE_DOC_027 NOMBREDOC027,t1.ID_TIPO_DOC_027 IDTIPODOC027 ");
		query.append("FROM AB0427S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0427stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0427stemp table.
	 * 
	 * ab0465stemp Ab0427stemp Long
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoOS2 ab0427stemp) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0427S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0427stemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0427stemp table using like.
	 * 
	 * ab0465stemp Ab0427stemp startsWith Boolean Long
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocumentoOS2 ab0427stemp, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0427S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0427stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0427stemp selected for rup_table
	 * 
	 * ab0427stemp Ab0427stemp jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<TableRowDto<Ab0427stemp>>.
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	// @Override
	public List<TableRowDto<DocumentoOS2>> reorderSelection(
			DocumentoOS2 ab0427stemp, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DOCUMENTO_027 IDDOCUMENTO027,t1.TEROS2_027 TEROS2027,t1.ANOOS2_027 ANOOS2027,t1.NUMOS2_027 NUMOS2027,t1.RUTA_PIF_027 RUTAPIF027,t1.NOMBRE_DOC_027 NOMBREDOC027,t1.ID_TIPO_DOC_027 IDTIPODOC027 ");
		// FROM
		query.append("FROM AB0427S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(ab0427stemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DocumentoOS2.class, filterParamList,
				"ID_DOCUMENTO_027");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * filterParams Ab0427stemp searchParams Ab0427stemp jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0427stemp>>.
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<DocumentoOS2>> search(DocumentoOS2 filterParams,
			DocumentoOS2 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DOCUMENTO_027 IDDOCUMENTO027,t1.TEROS2_027 TEROS2027,t1.ANOOS2_027 ANOOS2027,t1.NUMOS2_027 NUMOS2027,t1.RUTA_PIF_027 RUTAPIF027,t1.NOMBRE_DOC_027 NOMBREDOC027,t1.ID_TIPO_DOC_027 IDTIPODOC027 ");
		// FROM
		query.append("FROM AB0427S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DocumentoOS2.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_DOCUMENTO_027");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0427stemp entity
	 * 
	 * ab0427stemp Ab0427stemp Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoOS2 ab0427stemp) {

		StringBuilder where = new StringBuilder(
				DocumentosOS2TempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0427stemp != null && ab0427stemp.getIdDocumento094() != null) {
			where.append(" AND t1.ID_DOCUMENTO_027 = ?");
			params.add(ab0427stemp.getIdDocumento094());
		}
		if (ab0427stemp != null && ab0427stemp.getTramiteOS2() != null
				&& ab0427stemp.getTramiteOS2().getos2() != null
				&& ab0427stemp.getTramiteOS2().getos2().getTeros2060() != null) {
			where.append(" AND t1.TEROS2_027 = ?");
			params.add(ab0427stemp.getTramiteOS2().getos2().getTeros2060());
		}
		if (ab0427stemp != null && ab0427stemp.getTramiteOS2() != null
				&& ab0427stemp.getTramiteOS2().getos2() != null
				&& ab0427stemp.getTramiteOS2().getos2().getAnoos2060() != null) {
			where.append(" AND t1.ANOOS2_027 = ?");
			params.add(ab0427stemp.getTramiteOS2().getos2().getAnoos2060());
		}
		if (ab0427stemp != null && ab0427stemp.getTramiteOS2() != null
				&& ab0427stemp.getTramiteOS2().getos2() != null
				&& ab0427stemp.getTramiteOS2().getos2().getNumos2060() != null) {
			where.append(" AND t1.NUMOS2_027 = ?");
			params.add(ab0427stemp.getTramiteOS2().getos2().getNumos2060());
		}
		if (ab0427stemp != null && ab0427stemp.getRutaPif094() != null) {
			where.append(" AND t1.RUTA_PIF_027 = ?");
			params.add(ab0427stemp.getRutaPif094());
		}
		if (ab0427stemp != null && ab0427stemp.getNombreDoc094() != null) {
			where.append(" AND t1.NOMBRE_DOC_027 = ?");
			params.add(ab0427stemp.getNombreDoc094());
		}
		if (ab0427stemp != null && ab0427stemp.getTipoDocumento() != null
				&& ab0427stemp.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_0927 = ?");
			params.add(ab0427stemp.getTipoDocumento().getIdTipoDoc091());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0427stemp entity
	 * 
	 * ab0427stemp Ab0427stemp Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0427stemp
	 *            the ab 0427 stemp
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DocumentoOS2 ab0427stemp,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentosOS2TempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0427stemp != null && ab0427stemp.getIdDocumento094() != null) {
			where.append(" AND t1.ID_DOCUMENTO_027 = ?");
			params.add(ab0427stemp.getIdDocumento094());
		}
		if (ab0427stemp != null && ab0427stemp.getTramiteOS2() != null
				&& ab0427stemp.getTramiteOS2().getos2() != null
				&& ab0427stemp.getTramiteOS2().getos2().getTeros2060() != null) {
			where.append(" AND t1.TEROS2_027 = ?");
			params.add(ab0427stemp.getTramiteOS2().getos2().getTeros2060());
		}
		if (ab0427stemp != null && ab0427stemp.getTramiteOS2() != null
				&& ab0427stemp.getTramiteOS2().getos2() != null
				&& ab0427stemp.getTramiteOS2().getos2().getAnoos2060() != null) {
			where.append(" AND t1.ANOOS2_027 = ?");
			params.add(ab0427stemp.getTramiteOS2().getos2().getAnoos2060());
		}
		if (ab0427stemp != null && ab0427stemp.getTramiteOS2() != null
				&& ab0427stemp.getTramiteOS2().getos2() != null
				&& ab0427stemp.getTramiteOS2().getos2().getNumos2060() != null) {
			where.append(" AND t1.NUMOS2_027 = ?");
			params.add(ab0427stemp.getTramiteOS2().getos2().getNumos2060());
		}
		if (ab0427stemp != null && ab0427stemp.getRutaPif094() != null) {
			where.append(" AND UPPER(t1.RUTA_PIF_027) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0427stemp.getRutaPif094().toUpperCase() + "%");
			} else {
				params.add("%" + ab0427stemp.getRutaPif094().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RUTA_PIF_027 IS NOT NULL");
		}
		if (ab0427stemp != null && ab0427stemp.getNombreDoc094() != null) {
			where.append(" AND UPPER(t1.NOMBRE_DOC_027) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0427stemp.getNombreDoc094().toUpperCase() + "%");
			} else {
				params.add("%" + ab0427stemp.getNombreDoc094().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_DOC_027 IS NOT NULL");
		}
		if (ab0427stemp != null && ab0427stemp.getTipoDocumento() != null
				&& ab0427stemp.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_027 = ?");
			params.add(ab0427stemp.getTipoDocumento().getIdTipoDoc091());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
